/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class QDComboBoxUI
extends BasicComboBoxUI {
    protected ComboPopup createPopup() {
        BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox);
        basicComboPopup.getList().setForeground(Color.white);
        basicComboPopup.getList().setBackground(Color.black);
        basicComboPopup.getList().setSelectionForeground(Color.black);
        basicComboPopup.getList().setSelectionBackground(QDStdUI.getSelectedColor());
        return basicComboPopup;
    }

    protected JButton createArrowButton() {
        QDCbArrow qDCbArrow = new QDCbArrow();
        qDCbArrow.setName("ComboBox.arrowButton");
        return qDCbArrow;
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.darkGray);
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(QDStdUI.getButtonDark());
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(Color.gray);
            component.setBackground(QDStdUI.getButtonDark());
        }
        boolean bl2 = false;
        if (component instanceof JPanel) {
            bl2 = true;
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
    }

    private static class QDCbArrow
    extends BasicArrowButton {
        private static final long serialVersionUID = 1L;

        public QDCbArrow() {
            super(5, QDStdUI.getButtonDark(), QDStdUI.getButtonLight(), QDStdUI.getButtonLight().darker(), Color.white);
        }

        public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            Color color = graphics.getColor();
            int n5 = 0;
            n3 = Math.max(n3, 2);
            int n6 = n3 / 2 - 1;
            graphics.translate(n, n2);
            if (bl) {
                graphics.setColor(QDStdUI.getActionForeground());
            } else {
                graphics.setColor(Color.gray);
            }
            n5 = 0;
            for (int i = n3 - 1; i >= 0; --i) {
                graphics.drawLine(n6 - i, n5, n6 + i, n5);
                ++n5;
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

